using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmSupplyInventory
	/// </summary>
	public class FrmSupplyInventory : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables

		private BOL.VbecsReport _report;
		private System.Data.DataTable _dtReportData;
		
		#endregion

		#region FormControls

		private System.Windows.Forms.GroupBox grpImage1;
        private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvSupplyInventory;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		/// <param name="reportData"></param>
		public FrmSupplyInventory(BOL.VbecsReport report, System.Data.DataTable reportData)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._report = report;
			this._dtReportData = reportData;
			CreateReport();

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmSupplyInventory));
            this.grpImage1 = new System.Windows.Forms.GroupBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvSupplyInventory = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "Supply Inventory";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage1
            // 
            this.grpImage1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage1.Controls.Add(this.pictureBox2);
            this.grpImage1.Location = new System.Drawing.Point(4, 32);
            this.grpImage1.Name = "grpImage1";
            this.grpImage1.Size = new System.Drawing.Size(48, 412);
            this.grpImage1.TabIndex = 4;
            this.grpImage1.TabStop = false;
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(4, 12);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(40, 44);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox2.TabIndex = 1;
            this.pictureBox2.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 448);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 448);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            // 
            // rvSupplyInventory
            // 
            this.rvSupplyInventory.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvSupplyInventory.Location = new System.Drawing.Point(55, 37);
            this.rvSupplyInventory.Name = "rvSupplyInventory";
            this.rvSupplyInventory.Size = new System.Drawing.Size(584, 405);
            this.rvSupplyInventory.TabIndex = 6;
            // 
            // FrmSupplyInventory
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 473);
            this.Controls.Add(this.rvSupplyInventory);
            this.Controls.Add(this.grpImage1);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Update_Supply_Inventory_.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(600, 450);
            this.Name = "FrmSupplyInventory";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Supply Inventory";
            this.Load += new System.EventHandler(this.FrmSupplyInventory_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage1, 0);
            this.Controls.SetChildIndex(this.rvSupplyInventory, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage1.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Methods 

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC081.FrmSupplyInventory());
            BOL.VbecsReport.SetUpReportButtons(this.rvSupplyInventory);
        }

		private void CreateReport()
		{
			int nCount = 0;

			BOL.SupplyInventoryReport tmpTest = (BOL.SupplyInventoryReport)this._report;

			string reportCriteria = string.Empty;

			switch(tmpTest.InventoryFilter)
			{
				case Common.SupplyInventoryReportFilter.Expired:
					reportCriteria = "Expired Supplies";
					break;
				case Common.SupplyInventoryReportFilter.ExpiredWithDateRange:
					reportCriteria = "Expiration Date Range (";
					reportCriteria += Common.VBECSDateTime.FormatDateString(tmpTest.ExpirationStartDate) + " - ";
					reportCriteria += Common.VBECSDateTime.FormatDateString(tmpTest.ExpirationEndDate) + ")";
					break;
				case Common.SupplyInventoryReportFilter.InDate:
					reportCriteria = "In-Date Supplies";
					break;
				case Common.SupplyInventoryReportFilter.Unsatisfactory:
					reportCriteria = "Unsatisfactory Supplies";
					break;
			}

			reportCriteria += ", ";

			if (tmpTest.ReceiptEndDate != DateTime.MaxValue || tmpTest.ReceiptStartDate != DateTime.MinValue)
			{
				reportCriteria += "Received Date Range (";
				reportCriteria += Common.VBECSDateTime.FormatDateString(tmpTest.ReceiptStartDate) + " - ";
				reportCriteria += Common.VBECSDateTime.FormatDateString(tmpTest.ReceiptEndDate) + "), ";
			}

			System.Collections.ArrayList[] supplyTypes = BOL.Supply.GetSupplyTypeList();
			System.Collections.ArrayList supplyIds = supplyTypes[0];
			System.Collections.ArrayList supplyText = supplyTypes[1];


			if (tmpTest.SupplyTypeIds.Count >= supplyIds.Count)
			{
				reportCriteria += "Supply Types (ALL)";
			}
			else
			{
				reportCriteria += "Supply Types (";
				nCount = tmpTest.SupplyTypeIds.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					for(int typNdx=0; typNdx < supplyIds.Count; typNdx++)
					{
						//I saved the SupplyTypeIds as a string to make the sproc loading easier .. OYE!
						if (tmpTest.SupplyTypeIds[ndx].ToString() == supplyIds[typNdx].ToString())
						{
							if (ndx!=0) reportCriteria += ", ";
							reportCriteria += supplyText[typNdx].ToString();
							break;
						}
					}
				}
				reportCriteria += ")";
			}

			DataSet dsHeader =  BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
			DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

#if DEBUG
            //this._dtReportData.WriteXml("e:\\temp\\SupplyInventoryDataSet.xml", XmlWriteMode.WriteSchema);
#endif
            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "SupplyInventoryDataSet";
            reportSourceMain.Value = this._dtReportData;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.SupplyInventoryReport.SupplyInventoryReport.rdlc");

            this.rvSupplyInventory.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvSupplyInventory.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvSupplyInventory.LocalReport.DataSources.Add(reportSourceMain);
            this.rvSupplyInventory.LocalReport.LoadReportDefinition(stream);
            //this.rvSupplyInventory.RefreshReport();
		}

		#endregion
	
		#region Events / Event Handlers

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
            //CR 3449
            try
            {
                this.rvSupplyInventory.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

		#endregion

        private void FrmSupplyInventory_Load(object sender, EventArgs e)
        {

            this.rvSupplyInventory.RefreshReport();
        }
	}
}

